function [] = total_collate()
%This function works on an output data directory structure and generates a
%simplified experiment directory structure (collated_data), which is then
%used by join_verts and maybe join_sum.  For the expected structure of the
%input directory structure look at the syn_collate-directory.dia.
%Synatax:   [data] = syn_collate();
%Input:     you will be prompted to point to the root of the directory
%               structure.
%Output:    data = dataset of filenames and directory names

%initialize.
outsources = {};
outindexes = {};
out_table = {};

dir_root = uigetdir2('','Directory where the files are located');    %get the directory

dir_lv1 = dir(dir_root);    %get the file structure of the root dir.
out_root = [dir_root,filesep,['collated',datestr(now,'yyyymmdd.HHMM')],filesep];   %make the output directory structure root
mkdir(out_root);         %create the output root.

%now lets crank through the directories
for i = 3:size(dir_lv1,1)   %level 1: always start on 3 as 1 and 2 are . and .. (Dir: 20110308...etc.)
    if dir_lv1(i).isdir     %if this is a directory continue; else case...who cares
        dir_lv2 = dir([dir_root,filesep,dir_lv1(i).name]);  %now get the directory structure of the next level
        dir_tmp = [dir_root,filesep,dir_lv1(i).name,filesep]; %the current level 2 directory 
        if dir_end(dir_lv2)     %Test if this is the end level
            %Get here later
            error('There is a strict directory structure, and this is not it.');    %did not mean to use a strict directory structure
            %But storing an x possible drill down directory structure in a
            %n possible cell array, turns out to be too unwieldy.  Look at
            %the stored ver0.2 if you want to resurrect this, but for now
            %we are deadlocking this.  Check dir_struct.dia for the proper
            %directory structure.
        else    %not the end yet(expected)
            for j = 3:size(dir_lv2,1)   %level 2: Care about the name of this level (Dir: WT, KO, etc.)
                dir_lv3 = dir([dir_tmp,dir_lv2(j).name]);   %get the third level
                dir_tmp2 = [dir_tmp,dir_lv2(j).name,filesep];  %the current level3 directory
                if dir_end(dir_lv3)
                    %Come back for this later
                    error('There is a strict directory structure, and this is not it.');
                else    %no the end yet(expected)
                    for k = 3:size(dir_lv3,1)   %level 3: The care about level (Dir: Layer23, Layer4, etc.)
                        if dir_lv3(k).isdir     %go forth; we don't care about files
                            dir_lv4 = dir([dir_tmp2,dir_lv3(k).name]);   %get the fourth level
                            dir_tmp3 = [dir_tmp2,dir_lv3(k).name,filesep];  %the current level 4 directory
                            if dir_end(dir_lv4)
                                error(['There is a strict directory structure, and this is not it.',dir_tmp3]);
                            else
                                for l = 3:size(dir_lv4,1)   %level 4: The care about level (Dir: R1, R2, etc.)
                                    if dir_lv4(l).isdir     %go forth; we don't care about files
                                        dir_lv5 = dir([dir_tmp3,dir_lv4(l).name]);   %get the fourth level
                                        dir_tmp4 = [dir_tmp3,dir_lv4(l).name,filesep];  %the current level 4 directory
                                        %we only care about the files now.
                                        if size(dir_lv5,1)>2    %no empty directories
                                            [prop,countf,spcout] = process_files(dir_lv5);     %get the files we want to move
                                            %now setup the out put directory structure
                                            warning 'off'   %set it off so no annoying chirps for creating a directory
                                            mkdir(out_root,dir_lv2(j).name);    %KO
                                            mkdir([out_root,dir_lv2(j).name,filesep],dir_lv3(k).name);  %layer4
                                            %create out dir tmp
                                            if ~isempty(prop)
                                                out_prop = [out_root,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'prop',filesep];
                                                mkdir(out_prop);
                                                for n = 1:size(prop,2) %go through files and copy them to new destinations
                                                    copyfile([dir_tmp4,prop{n}],[out_prop,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_prop_',prop{n}(spcout(n,1)+1:spcout(n,2)-1),'.csv']);
                                                end
                                                %save out the count files
                                                out_count = [out_root,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'count',filesep];
                                                mkdir(out_count);
                                                sav2csv(countf,[padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_count_summary.csv'],out_count);
                                            end
                                            outsources = vertcat(outsources,dir_tmp4);  %where the data is coming from
                                            outindexes = vertcat(outindexes,{padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4)}); %what number we gave to data from this set
                                            warning 'on'    %back on
                                        end
                                        %create a look up table for output
                                        %index and the date, condition, layer,
                                        %region...
                                        out_table = vertcat(out_table,{dir_lv1(i).name,dir_lv2(j).name,dir_lv3(k).name,dir_lv4(l).name,'total',padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4)});
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
outdata = dataset(outindexes,'ObsNames',outsources,'VarNames',{'index'});
sav2csv(outdata,'output_summary.csv',out_root);
sav2csv(out_table,'output_lookup.csv',out_root);
        
        
%--------------------------------------------------------------------------
%sub function to figure out if this level is only files, meaning this is
%the end dir.
function [is_end] = dir_end(dir_struct)

is_end = 0;  %initiate

for i = 3:size(dir_struct,1)    %go through the 
    is_end(i-2)=dir_struct(i).isdir;     %pull the isdir info
end

is_end = logical(1-max(is_end));       %readout of whether this directory has only files.

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [prop,countf,spcout] = process_files(dir_info)

curr_names = {dir_info.name};   %grab the all of the names
idx = [dir_info.isdir];   %grab all of the isdir numbers
filenames = curr_names(~idx);   %grab the files first
filenames = findfiletype(filenames,'.csv');  %only csvs

%filter for only the files we want
prop_idx = ones(size(filenames));   %same for prop
spcout = [];
for j = 1:size(filenames,2);
    spc = strfind(filenames{j},' ');  %get the spaces
    if isempty(spc)
        prop_idx(j) = 0;    %set this for removal
    else %it is a prop file
        %generate a count file
        prd = strfind(filenames{j},'.');  %get the periods
        celllabels{j} = filenames{j}(spc(1)+1:spc(2)-1);  %create a cell array of file names to label the count files
        countnum(j) = str2num(filenames{j}(prd(1)+1:prd(2)-1));
        spcout = vertcat(spcout,spc);
    end
end
%create the desired lists of file names.
prop = filenames(logical(prop_idx));    %list for prop files
%create count file
countf = dataset(countnum','ObsNames',celllabels','VarNames',{'count'});
